<?PHP
CheckAuthorization(PRIV_USERADMIN, PRIV_SYSADMIN);

# ----- MAIN -----------------------------------------------------------------

global $FTool;

PageTitle("New User Sign-Up");

$ExistingUserName = isset($_GET["ExistingUserName"]) ? $_GET["ExistingUserName"] : "";

# set up expectations for incoming form
$AdditionalErrorMessages = array(
        U_EMAILSDONTMATCH   => "The two e-mail addresses you entered did not match.",
        U_DUPLICATEUSERNAME => "The user name you entered is already in use.",
        U_ILLEGALUSERNAME   => "The user name you entered is not valid."
                ." User names must be made up of one word containing between 2 and 24"
                ." letters and/or numbers.",
        U_ILLEGALEMAIL      => "The email you entered is not valid.",
        U_MAILINGERROR      => "An error was encountered trying to send an"
                ." e-mail message to activate your new account.  Please contact the"
                ." administrator of this site and inform them of the problem.",
        U_DUPLICATEEMAIL => "The e-mail address you entered is already associated"
        ." with user '".$ExistingUserName."'",
        );

$AdditionalErrorMessages =
    $AF->SignalEvent("EVENT_USER_SIGNUP_EXTEND_ERROR_LIST",
                     array($AdditionalErrorMessages));

$FTool = new FormTool("RequestAccount", array_shift($AdditionalErrorMessages));
$FTool->SetFieldValuesFromUrlParams();

?>
