<?PHP
#
#   FILE:  DeleteTopic.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2004-2013 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

PageTitle("Delete Topic");

if (!CheckAuthorization( PRIV_SYSADMIN )) {  return;  }

if (!isset($_GET["TI"]) )
{
    $H_ErrorMessages[]= "No TopicId specified";
    return;
}

# Pull out the requsted topic, make sure that it exists.
# Bounce the user to Unauthorized if they asked for a topic that we do not have.

$H_Topic = new Topic( intval($_GET["TI"]));
if ($H_Topic->GetErrorStatus() != Topic::OK)
{
    $H_ErrorMessages[]= "Invalid TopicId specified";
    return;
}

$H_Forum = new Forum( $H_Topic->ForumId() );
