<?PHP
#
#   FILE:  Pages_Page.php (Pages plugin)
#
#   Copyright 2012 Edward Almasy and Internet Scout
#   http://scout.wisc.edu
#

class Pages_Page {

    # ---- PUBLIC INTERFACE --------------------------------------------------

    function __construct($PageId)
    {
        # save page ID
        $this->Id = $PageId;

        # set up our own database connection
        $this->DB = new Database();

        # load page data
        $this->DB->Query("SELECT * FROM Pages_Pages WHERE PageId = "
                .intval($this->Id));

        # if page data load failed
        if (!$this->DB->NumRowsSelected())
        {
            # throw error exception
            throw new Exception("Attempt to load unknown page (ID=".$this->Id.").");
        }
        else
        {
            # read page data into local cache
            $this->DBFields = $this->DB->FetchRow();
        }
    }

    function Id() {  return $this->Id;  }

    function Title($NewValue = DB_NOVALUE)
        {  return $this->UpdateValue("PageTitle", $NewValue);  }
    function Content($NewValue = DB_NOVALUE)
        {  return $this->UpdateValue("PageContent", $NewValue);  }
    function CleanUrl($NewValue = DB_NOVALUE)
        {  return $this->UpdateValue("CleanUrl", $NewValue);  }
    function AuthorId($NewValue = DB_NOVALUE)
        {  return $this->UpdateValue("AuthorId", $NewValue);  }
    function EditorId($NewValue = DB_NOVALUE)
        {  return $this->UpdateValue("EditorId", $NewValue);  }
    function UpdatedOn($NewValue = DB_NOVALUE)
        {  return $this->UpdateValue("UpdatedOn", $NewValue);  }
    function CreatedOn($NewValue = DB_NOVALUE)
        {  return $this->UpdateValue("CreatedOn", $NewValue);  }

    function Privileges($NewValue = NULL)
    {
        # if new set of privileges specified
        if ($NewValue !== NULL)
        {
            # clear out any old privileges
            $this->DB->Query("DELETE FROM Pages_Privileges"
                    ." WHERE PageId = ".intval($this->Id));

            # save new set of privileges locally
            $this->Privileges = $NewValue;

            # save new set of privileges to database
            foreach ($this->Privileges as $Priv)
            {
                $this->DB->Query("INSERT INTO Pages_Privileges SET"
                        ." PageId = ".intval($this->Id).","
                        ." Privilege = ".intval($Priv));
            }
        }
        else
        {
            # if we do not already have privileges
            if (!isset($this->Privileges))
            {
                # read privileges in from database
                $this->DB->Query("SELECT Privilege FROM Pages_Privileges"
                        ." WHERE PageId = ".intval($this->Id));
                $this->Privileges = $this->DB->FetchColumn("Privilege");
            }
        }

        # report current privileges to caller
        return $this->Privileges;
    }

    /**
    * Check whether specified (or current) user can edit/delete page.
    * @param User User to check privileges for.  (OPTIONAL, if no user
    *       supplied then currently-logged-in user (if any) is used)
    * @return TRUE if user can edit, otherwise FALSE.
    */
    function UserCanEdit($User = NULL)
    {
        # if no user supplied use current user
        if ($User == NULL) {  $User = $GLOBALS["G_User"];  }

        # start with edit privilege
        $Plugin = $GLOBALS["G_PluginManager"]->GetPlugin("Pages");
        $NeededPrivileges = array($Plugin->ConfigSetting("PrivilegeToEdit"));

        # add in author privilege if user was original author
        if ($User->IsLoggedIn() && ($User->Id() == $this->AuthorId()))
        {
            $NeededPrivileges[] = $Plugin->ConfigSetting("PrivilegeToAuthor");
        }

        # check privileges and report result back to caller
        return $User->HasPriv($NeededPrivileges) ? TRUE : FALSE;
    }

    # ---- PRIVATE INTERFACE -------------------------------------------------

    private $DB;
    private $Id;
    private $DBFields;
    private $Privileges;

    private function UpdateValue($FieldName, $NewValue)
    {
        return $this->DB->UpdateValue("Pages_Pages", $FieldName, $NewValue,
                "PageId = ".intval($this->Id), $this->DBFields);
    }

}


