<?PHP
#
#   FILE:  Subscribe.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2013 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

# ----- MAIN -----------------------------------------------------------------

PageTitle("Subscribe to Blog Entry Notifications");

# get the blog plugin
$Blog = $GLOBALS["G_PluginManager"]->GetPluginForCurrentPage();

# if user is logged in
if ($GLOBALS["G_User"]->IsLoggedIn())
{
    # change the subscription for the user
    $Blog->ChangeNotificationSubscription($GLOBALS["G_User"], TRUE);

    # go back to the blog landing page
    $GLOBALS["AF"]->SetJumpToPage($Blog->BlogUrl());
}
else
{
    # send user to login page with appropriate prompt
    $_SESSION["LoginPrompt"] = $Blog->ConfigSetting("NotificationLoginPrompt");
    $GLOBALS["AF"]->SetJumpToPage("Login");
}
