
CREATE TABLE IF NOT EXISTS ApplicationFrameworkSettings (
    MaxExecTime                     INT DEFAULT 300,
    TaskExecutionEnabled            INT DEFAULT 1,
    MaxTasksRunning                 INT DEFAULT 2,
    LastTaskRunAt                   DATETIME,
    TemplateLocationCache           MEDIUMBLOB,
    TemplateLocationCacheExpiration DATETIME,
    TemplateLocationCacheInterval   INT DEFAULT 15,
    ObjectLocationCache             MEDIUMBLOB,
    ObjectLocationCacheExpiration   DATETIME,
    ObjectLocationCacheInterval     INT DEFAULT 60,
    LoggingLevel                    INT DEFAULT 4,
    BasePath                        TEXT,
    BasePathCheck                   TEXT,
    LogSlowPageLoads                INT DEFAULT 0,
    SlowPageLoadThreshold           INT DEFAULT 10
);

CREATE TABLE IF NOT EXISTS TaskQueue (
    TaskId      INT NOT NULL AUTO_INCREMENT,
    Callback    MEDIUMTEXT,
    Parameters  MEDIUMTEXT,
    Priority    INT,
    Description TEXT,
    INDEX       (TaskId),
    INDEX       (Callback(64), Parameters(256))
);

-- (RunningTasks table must match TaskQueue table except for StartedAt and CrashInfo)
CREATE TABLE IF NOT EXISTS RunningTasks (
    TaskId      INT,
    Callback    MEDIUMTEXT,
    Parameters  MEDIUMTEXT,
    Priority    INT,
    Description TEXT,
    StartedAt   TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    CrashInfo   MEDIUMBLOB,
    INDEX       (TaskId),
    INDEX       (Callback(64), Parameters(256))
);

CREATE TABLE IF NOT EXISTS PeriodicEvents (
    Signature   TEXT,
    LastRunAt   DATETIME
);
