<?PHP
#
#   FILE:  ChangeResourceNote.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2012 Internet Scout Project
#   http://scout.wisc.edu/
#

# ----- MAIN -----------------------------------------------------------------

global $Folder;
global $FolderId;
global $ItemId;
global $Note;
global $ReturnTo;

PageTitle("Change Resource Note");

# make sure the user is logged in
if (!CheckAuthorization()) return;

$FolderId = GetArrayValue($_GET, "FolderId");
$ItemId = GetArrayValue($_GET, "ItemId");

# redirect if no IDs are given
if (!strlen($FolderId) || !strlen($ItemId))
{
    $AF->SetJumpToPage("P_Folders_ManageFolders");
    return;
}

try
{
    $FolderFactory = new Folders_FolderFactory($User->Id());
    $ResourceFolder = $FolderFactory->GetResourceFolder();
    $Folder = new Folders_Folder(GetArrayValue($_GET, "FolderId"));
    $Resource = new Resource($ItemId);

    # redirect if the user should not see the folder
    if (!$ResourceFolder->ContainsItem($Folder->Id()))
    {
        $AF->SetJumpToPage("P_Folders_ManageFolders");
        return;
    }

    # make sure the resource is valid and belongs to the folder
    else if ($Resource->Status() !== 1 || !$Folder->ContainsItem($Resource->Id()))
    {
        $AF->SetJumpToPage("P_Folders_ManageFolders");
        return;
    }

    $FolderId = $Folder->Id();
    $ItemId = $Resource->Id();
    $Note = $Folder->NoteForItem($Resource->Id());
    $ReturnTo = defaulthtmlentities(GetArrayValue($_GET, "ReturnTo"));
}

# redirect if given a bad folder ID
catch (Exception $Exception)
{
    $AF->SetJumpToPage("P_Folders_ManageFolders");
    return;
}
