<?PHP
#
#   FILE:  Plugins.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2013 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

PageTitle("CWIS Plugins");

# check that the user has sufficient privileges
if (!CheckAuthorization(PRIV_SYSADMIN)) {  return;  }

# if form was submitted
if (isset($_POST["SUBMITTED"]))
{
    # for each plugin
    global $G_PluginManager;
    $Attribs = $G_PluginManager->GetPluginAttributes();
    foreach ($Attribs as $PluginName => $Attrib)
    {
        # updated enable/disable setting to reflect form checkboxes
        $G_PluginManager->PluginEnabled($PluginName,
                (($PluginName == "CWISCore")
                || isset($_POST["EnabledCheckbox-".$PluginName]))
                ? TRUE : FALSE);
    }

    # reload plugins to reflect updated enable/disable settings
    $G_PluginManager->LoadPlugins();
}


?>
