<?PHP

#
#   FILE:  PasswordFormField.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2013 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

  /**
   * Abstraction for password forms
   * \nosubgrouping
   */

class PasswordFormField extends TextFormField {
    /** @name Setup/Initialization */
    /*@{*/

    /**
     * Object Constructor
     * @param string $Name internal name for this field, used for html id=
     * @param bool $IsRequired whether or not the field is required
     * @param string $Label display name for this field, shown to the user
     * @param int $Length minimum length for a password
     * @param int $MaxLength maximum length allowed
     * @param callback $ValidFunc function to validate entered data
     * @param array $ValidMsgs error messages associated with error codes from ValidFunc
     */
    function PasswordFormField(
            $Name, $IsRequired, $Label, $Length, $MaxLength,
            $ValidFunc = NULL, $ValidMsgs = NULL)
    {
        $this->TextFormField(
                $Name, $IsRequired, $Label, $Length, $MaxLength, $ValidFunc, $ValidMsgs);
    }

    /*@}*/
}

?>
