<?PHP
#
#   FILE:  ForumTopics.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2004-2013 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

PageTitle("Forums Topics");

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

function PrintForumId()
{
    global $ForumId;

    print $ForumId;
}

function PrintForumDescription()
{
    global $ForumDescription;

    print $ForumDescription;
}

function PrintTopicCount()
{
    global $TopicCount;

    print $TopicCount;
}

function PrintMessageCount()
{
    global $MessageCount;

    print $MessageCount;
}

function PrintForumName()
{
    global $ForumName;

    print $ForumName;
}

function PrintURLEncodeForumName()
{
    global $ForumName;

    print urlencode($ForumName);
}

function PrintTopicName()
{
    global $TopicName;

    print $TopicName;
}

function PrintTopicId()
{
    global $TopicId;

    print $TopicId;
}

function PrintViewCount()
{
    global $ViewCount;

    print $ViewCount;
}

function PrintCreator()
{
    global $Creator;

    if (strlen($Creator)>0)
        print $Creator;
    else
        print "[deleted&nbsp;account]";
}

function PrintCreatorEmail()
{
    global $CreatorEmail, $User;
    if ($User->IsLoggedIn() && strlen($CreatorEmail)>0)
    {
        print "(".MungeEmailAddress($CreatorEmail).")";
    }
}

function PrintLastMessage()
{
    global $LastMessage;

    print $LastMessage;
}

function PrintPoster()
{
    global $Poster;

    print $Poster;
}

function PrintPosterEmail()
{
    global $PosterEmail, $User;
    if ($User->IsLoggedIn() && strlen($PosterEmail)>0)
    {
        print "(".MungeEmailAddress($PosterEmail).")";
    }
}

function DisplayTopics()
{
    global $ForumId;
    global $LastMessage, $Poster, $PosterId;
    global $TopicName, $TopicId, $MessageCount;
    global $ViewCount, $Creator, $CreatorEmail;
    global $Topic;

    $Forum = new Forum($ForumId);
    if ($Forum->GetErrorStatus() == Forum::OK)
    {
        $Topics = $Forum->GetTopicList();

        foreach ($Topics as $TopicId => $Topic)
        {
            $TopicName = $Topic->TopicName();
            $ForumId = $Topic->ForumId();
            $MessageCount = $Topic->MessageCount();
            $ViewCount = $Topic->ViewCount();
            $Creator = $Topic->CreatorName();
            $CreatorEmail = $Topic->CreatorEmail();

        # get last message posted for this topic
            LastMessage();
            PrintTopic();
        }
    }
}

# ----- LOCAL FUNCTIONS ------------------------------------------------------

function LastMessage()
{
    global $LastMessage, $Poster, $PosterEmail, $TopicId;

    $LastMessage = "None";
    $Poster = NULL;
    $PosterEmail = NULL;

    $Topic = new Topic($TopicId);
    $AllMessages = $Topic->GetMessageList();

    $Message = array_pop($AllMessages);

    $LastMessage = $Message->DatePosted();
    $Poster = $Message->PosterName();
    $PosterEmail = $Message->PosterEmail();

    If($LastMessage != "None")
        $LastMessage .= " by ";
}

function GetForumInfo($ForumId)
{
    global $ForumName, $ForumDescription, $TopicCount, $MessageCount;
    global $ModeratorId, $Moderator, $ModeratorEmail;

    $Forum = new Forum($ForumId);

    $ForumName = $Forum->ForumName();
    $ForumDescription = $Forum->ForumDescription();
    $TopicCount = $Forum->TopicCount();
    $MessageCount = $Forum->MessageCount();
    $ModeratorId = $Forum->ModeratorId();
    $ModeratorName = $Forum->ModeratorName();
    $ModeratorEmail = $Forum->ModeratorEmail();
}

# ----- MAIN -----------------------------------------------------------------

# non-standard global variables
global $Creator;
global $CreatorEmail;
global $ForumDescription;
global $ForumId;
global $ForumName;
global $LastMessage;
global $MessageCount;
global $Moderator;
global $ModeratorEmail;
global $ModeratorId;
global $Poster;
global $PosterEmail;
global $PosterId;
global $Topic;
global $TopicCount;
global $TopicId;
global $TopicName;
global $ViewCount;

# obtain useful info for this forum
if (isset($_POST["ForumId"]))
{
    $ForumId = intval($_POST["ForumId"]);
}
else if (isset($_GET["FI"]))
{
    $ForumId = intval($_GET["FI"]);
}
else if (isset($_SESSION["ForumId"]))
{
    # redirect to this page to use GET parameters since the session ones won't
    # exist if someone refreshes or clicks a link and clicks the back button
    $AF->SetJumpToPage("index.php?P=ForumTopics&FI="
        .$_SESSION["ForumId"]);
    unset($_SESSION["ForumId"]);
    return;
}

if (isset($ForumId))
    GetForumInfo($ForumId);
