<?PHP
#
#   FILE:  PostMessage.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2012-2013 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

require_once("lib/AxisPHP/Axis--StandardLibrary.php");

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

function CheckForEdit($Message, $Forum)
{
    global $G_User;

    return $G_User->Id() == $Forum->ModeratorId() ||
        $G_User->Id() == $Message->PosterId() ||
        $G_User->HasPriv(PRIV_SYSADMIN);
}

# ----- LOCAL FUNCTIONS ------------------------------------------------------

function GetFromSession($VarName){
    $Value = NULL;
    if (isset($_SESSION[$VarName]))
    {
        $Value = $_SESSION[$VarName];
        unset ($_SESSION[$VarName]);
    }
    return $Value;
}

# ----- MAIN -----------------------------------------------------------------

PageTitle("Post Message");

if (!CheckAuthorization( PRIV_POSTTOFORUMS, PRIV_FORUMADMIN, PRIV_SYSADMIN )) {  return;  }

if (isset($_SESSION["ErrorMessages"]))
    $H_ErrorMessages = GetFromSession("ErrorMessages");

if (!isset($_GET["TI"]) )
{
    $H_ErrorMessages []= "No TopicId specified";
    $H_Fatal = TRUE;
    return;
}

$H_Topic = new Topic( intval($_GET["TI"]) );

if ($H_Topic->GetErrorStatus() != Topic::OK)
{
    $H_ErrorMessages []= "Invalid TopicId specified";
    $H_Fatal = TRUE;
    return;
}

$H_Forum = new Forum( $H_Topic->ForumId() );

if (isset($_GET["MI"]))
{
    $H_Message = new Message( intval($_GET["MI"]) );

    # Try to extract the quested message, but bounce the user if it doesn't exist:
    if ($H_Message->GetErrorStatus() != Message::OK)
    {
        $H_ErrorMessages []= "Invalid MessageId specified";
        $H_Fatal = TRUE;
    }

    $H_Subject = isset($_SESSION["Subject"])
        ? GetFromSession("Subject") : $H_Message->Subject();
    $H_Body = isset($_SESSION["Body"])
        ? GetFromSession("Body") : $H_Message->Body();
}
else
{
    if (isset($_POST["Subject"]))
        $H_Subject = $_POST["F_Subject"];
    elseif (isset($_SESSION["Subject"]))
        $H_Subject = GetFromSession("Subject");
    else
        $H_Subject = "";

    if (isset($_POST["Body"]))
        $H_Body = $_POST["F_Body"];
    elseif (isset($_SESSION["Body"]))
        $H_Body = GetFromSession("Body");
    else
        $H_Body = "";
}

# initialize variables related to the reply to message
$ReplyToId = GetArrayValue($_GET, "ReplyTo");
$H_ReplyTo = NULL;

# if given a reply to message ID and not editing an existing message
if (!is_null($ReplyToId) && !isset($H_Message))
{
    $H_ReplyTo = new Message($ReplyToId);

    # the message ID is invalid
    if ($H_ReplyTo->GetErrorStatus() !== Message::OK)
    {
        $H_ReplyTo = NULL;
    }

    # the message belongs to a different topic
    else if ($H_ReplyTo->ParentId() != $H_Topic->TopicId())
    {
        $H_ReplyTo = NULL;
    }

    if (!is_null($H_ReplyTo))
        $H_Subject = $H_ReplyTo->Subject();
}
