<?PHP

/**
* Peform any follow-up tasks after an upgrade.  Tasks that go here are
*   typically those that can be performed after the site is in use.
*/
function PerformUpgradeFollowUp($OldVersion)
{
    # queue complete search DB rebuild
    $SearchEngine = new SPTSearchEngine();
    $RFactory = new ResourceFactory();
    $Ids = $RFactory->GetItemIds();
    foreach ($Ids as $Id)
    {
        $SearchEngine->QueueUpdateForItem($Id,
                ApplicationFramework::PRIORITY_BACKGROUND);
    }

    # queue complete recommender DB rebuild
    $Recommender = new SPTRecommender();
    foreach ($Ids as $Id)
    {
        $Recommender->QueueUpdateForItem((int)$Id,
                ApplicationFramework::PRIORITY_BACKGROUND);
    }
    $GLOBALS["AF"]->QueueUniqueTask(array($Recommender, "PruneCorrelations"),
                array(), ApplicationFramework::PRIORITY_BACKGROUND);

    # recalculate all resource counts
    $ClassificationFactory = new ClassificationFactory();
    $ClassificationFactory->RecalculateAllResourceCounts();
}
