<?PHP
#
#   FILE:  NewSavedSearch.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2011-2013 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

function PrintErrorMessage()
{
    global $Session;

    $ErrorMessage = $Session->Get("ErrorMessage");

    if (!empty($ErrorMessage))
    {
        print("<ul>\n");
        printf("<li><b>%s</b></li>\n", $ErrorMessage);
        print("</ul>\n");
    }
}

function PrintFrequencyOptionList()
{
    global $User;
    if ($User->HasPriv(PRIV_RESOURCEADMIN))
    {
        $FreqList = SavedSearch::GetSearchFrequencyList();
    }
    else
    {
        $FreqList = SavedSearch::GetSearchFrequencyList(SavedSearch::SEARCHFREQ_HOURLY);
    }
    PrintOptionList("F_SearchFreq", $FreqList, SavedSearch::SEARCHFREQ_NEVER);
}

function PrintCriteria()
{
    global $SearchGroups;
    $CriteriaText = SavedSearch::TranslateSearchGroupsToTextDescription(
            $SearchGroups);
    print $CriteriaText;
}

function PrintFormUrl()
{
    global $SearchGroups;
    print("index.php?P=SavedSearch&amp;"
          .SavedSearch::TranslateSearchGroupsToUrlParameters($SearchGroups));
}

# ----- LOCAL FUNCTIONS ------------------------------------------------------

# ----- MAIN -----------------------------------------------------------------

# (for PrintOptionList())
include_once "lib/AxisPHP/Axis--StandardLibrary.php";

# non-standard global variables
global $SearchGroups;

PageTitle("Save Search");

$SearchGroups = SavedSearch::TranslateUrlParametersToSearchGroups($_GET);
