<?PHP

#
#   FILE:  SPT--ConfirmDeleteTopic.php
#
#   FUNCTIONS PROVIDED:
#       PrintTopicName()
#       - print out topic name
#
#       PrintForumName()
#       - print out forum name
#
#   FUNCTIONS EXPECTED:
#
#   Part of the Scout Portal Toolkit
#   Copyright 2004 Internet Scout Project
#   http://scout.cs.wisc.edu
#

PageTitle("Confirm Delete Topic");

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

function PrintTopicName()
{
    global $TopicName;

    print $TopicName;
}

function PrintForumName()
{
    global $ForumName;

    print $ForumName;
}

# ----- LOCAL FUNCTIONS ------------------------------------------------------

# ----- MAIN -----------------------------------------------------------------

# non-standard global variables
global $ForumName;
global $TopicName;

if (!CheckAuthorization( PRIV_SYSADMIN )) {  return;  }

if (isset($_GET["TopicId"]) && isset($_GET["ForumId"]))
{
    $TopicId = $_GET["TopicId"];

    $Topic = new Topic($TopicId);
    $TopicName = $Topic->TopicName();

    $ForumId = $_GET["ForumId"];
    $Forum = new Forum($ForumId);
    $ForumName = $Forum->ForumName();

    # Stuff the state variables back into the sesion
    # so that they'll be there for UpdateTopic.
    $_SESSION["TopicId"] = $TopicId;
    $_SESSION["ForumId"] = $ForumId;
}

?>
