<?PHP
#
#   FILE:  EditMessageTemplate.php (Mailer plugin)
#
#   Copyright 2012 Edward Almasy and Internet Scout
#   http://scout.wisc.edu
#

# check that user should be on this page
CheckAuthorization(PRIV_COLLECTIONADMIN, PRIV_SYSADMIN);

# load up current templates
$Plugin = $GLOBALS["G_PluginManager"]->GetPluginForCurrentPage();
$G_Templates = $Plugin->ConfigSetting("Templates");

# take action based on which button was pushed or which action was requested
$Action = isset($_POST["Submit"]) ? $_POST["Submit"]
        : (isset($_GET["AC"]) ? $_GET["AC"] : NULL);
$Id = isset($_POST["F_Id"]) ? $_POST["F_Id"]
        : (isset($_GET["ID"]) ? $_GET["ID"] : NULL);
$G_TestSeed = isset($_POST["F_TestSeed"]) ? $_POST["F_TestSeed"]
        : (isset($_GET["TS"]) ? $_GET["TS"] : floor(time()/(60*60*24)));
switch ($Action)
{
    case "Add Template":
        # set up blank template
        $Id = "NEW";
        $G_Templates[$Id]["Name"] = "";
        $G_Templates[$Id]["From"] = "X-PORTALNAME-X <X-ADMINEMAIL-X>";
        $G_Templates[$Id]["Subject"] = "";
        $G_Templates[$Id]["Body"] = "";
        $G_Templates[$Id]["ItemBody"] = "";
        $G_Templates[$Id]["PlainTextBody"] = "";
        $G_Templates[$Id]["PlainTextItemBody"] = "";
        $G_Templates[$Id]["Headers"] = "";
        $G_Templates[$Id]["CollapseBodyMargins"] = FALSE;

        # set flag to display template editing form
        $G_DisplayMode = "Adding";
        break;

    case "Edit":
    case "Delete":
        # set display mode flag to editing or deletion confirmation as appropriate
        $G_DisplayMode = ($Action == "Delete") ? "Confirm" : "Editing";
        break;

    case "Confirm":
        # delete template
        unset($G_Templates[$Id]);
        $Plugin->ConfigSetting("Templates", $G_Templates);

        # set flag to display template list
        $G_DisplayMode = "Listing";
        break;

    case "Save":
    case "Test":
        # if new template
        if ($Id == "NEW")
        {
            # get next template ID
            $Id = (($G_Templates === NULL) || !count($G_Templates)) ? 0
                    : (max(array_keys($G_Templates)) + 1);
        }

        # save template
        $G_Templates[$Id] = array(
                "Name" => $_POST["F_Name"],
                "From" => $_POST["F_From"],
                "Subject" => $_POST["F_Subject"],
                "Body" => $_POST["F_Body"],
                "CollapseBodyMargins" => !!$_POST["F_CollapseBodyMargins"],
                "ItemBody" => $_POST["F_ItemBody"],
                "PlainTextBody" => $_POST["F_PlainTextBody"],
                "PlainTextItemBody" => $_POST["F_PlainTextItemBody"],
                "Headers" => $_POST["F_Headers"],
                );
        $Plugin->ConfigSetting("Templates", $G_Templates);
        $G_Msgs[] = "<i>".htmlspecialchars($G_Templates[$Id]["Name"])
                ."</i> template saved.";

        # if we are to send a test email
        if ($Action == "Test")
        {
            # retrieve resources to use for test email
            $RFactory = new ResourceFactory();
            $Ids = $RFactory->GetItemIds();
            srand($G_TestSeed);
            $ResourceCount = rand(1, 20);
            $Resources = array();
            for ($Index = 0;  $Index < $ResourceCount;  $Index++)
            {
                $ResourceId = $Ids[rand(0, count($Ids) - 1)];
                $Resources[$ResourceId] = new Resource($ResourceId);
            }

            # send out test email to current user
            $Plugin->SendEmail($Id, $GLOBALS["G_User"]->Id(), $Resources);
            $G_Msgs[] = "Test email sent for <i>"
                    .htmlspecialchars($G_Templates[$Id]["Name"])."</i> template.";
        }

        # set display mode flag to editin or template list depending on actiong
        $G_DisplayMode = ($Action == "Test") ? "Editing" : "Listing";
        break;

    case "Cancel":
    default:
        # set flag to display template list
        $G_DisplayMode = "Listing";
        break;
}

# load values for selected template if needed
if (in_array($G_DisplayMode, array("Editing", "Adding", "Confirm")))
{
        $G_Id = $Id;
        $G_Name = $G_Templates[$Id]["Name"];
        $G_From = $G_Templates[$Id]["From"];
        $G_Subject = $G_Templates[$Id]["Subject"];
        $G_Body = $G_Templates[$Id]["Body"];
        $G_CollapseBodyMargins = $G_Templates[$Id]["CollapseBodyMargins"];
        $G_ItemBody = $G_Templates[$Id]["ItemBody"];
        $G_PlainTextBody = $G_Templates[$Id]["PlainTextBody"];
        $G_PlainTextItemBody = $G_Templates[$Id]["PlainTextItemBody"];
        $G_Headers = $G_Templates[$Id]["Headers"];
}
