<?PHP
#
#   FILE:  UpdateQualifier.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2012 Internet Scout Project
#   http://scout.wisc.edu/
#

# ----- LOCAL FUNCTIONS ------------------------------------------------------

# get list of qualifiers to remove
function GetRemoveList()
{
    $Schema = new MetadataSchema();

    $Qualifiers = array();
    foreach ($_POST as $Var => $Value)
    {
        if (preg_match("/qid_[0-9]+/", $Var))
        {
            if ($Value != "")
            {
                $Qualifiers[] = $Value;
            }
        }
    }
    return $Qualifiers;
}

# remove list value
function RemoveListValue()
{
    global $Session;

    $Schema = new MetadataSchema();
    $RFactory = new ResourceFactory();

    $Qualifiers = $Session->Get("Qualifiers");

    foreach ($Qualifiers as $QualifierId)
    {
        $Qualifier = new Qualifier($QualifierId);
        $Schema->RemoveQualifierAssociations($Qualifier);
        $RFactory->ClearQualifier($Qualifier);
        $Qualifier->Delete();
    }
}

# add list value
function AddListValue()
{
    global $ErrorMessages;
    global $Session;
    global $F_NewName;
    global $F_NewNamespace;
    global $F_NewUrl;

    $QualifierFactory = new QualifierFactory();

    # escape quotes
    $F_NewName = addslashes($F_NewName);
    $F_NewNamespace = addslashes($F_NewNamespace);
    $F_NewUrl = addslashes($F_NewUrl);

    # first check to see if it already exists
    if (!empty($F_NewName))
    {
        if ($QualifierFactory->QualifierNameIsInUse($F_NewName))
        {
            $ErrorMessages[] = "<b>Error: </b>".$F_NewName." already exists";
            return;
        }

        # create new qualifier
        $Qualifier = new Qualifier();
        $Qualifier->Name($F_NewName);
        $Qualifier->NSpace($F_NewNamespace);
        $Qualifier->Url($F_NewUrl);
    }
    else
        $ErrorMessages[] = "<b>Error: </b>No Value Entered";
}

# update list value
function UpdateListValue()
{
    global $_POST, $DB;

    foreach ($_POST as $Var => $Value)
    {
        if (preg_match("/qid_[0-9]+/", $Var))
        {
            if (isset($Value))
                $QualifierId = $Value;
            else
                continue;
        }
        if (preg_match("/qn_[0-9]+/", $Var))
        {
            if (isset($Value))
                $QualifierName = addslashes($Value);
            else
                continue;
            # add check here to see if it already exists
        }
        if (preg_match("/qs_[0-9]+/", $Var))
        {
            if (isset($Value))
                $QualifierNamespace = addslashes($Value);
            else
                continue;
            # add check here to see if it already exists
        }
        if (preg_match("/qu_[0-9]+/", $Var))
        {
            $Value = trim($Value);
            $QualifierUrl = addslashes($Value);
            if (!empty($QualifierName) && isset($QualifierId))
            {
                # create new qualifier
                $Qualifier = new Qualifier($QualifierId);
                $Qualifier->Name($QualifierName);
                $Qualifier->NSpace($QualifierNamespace);
                $Qualifier->Url($QualifierUrl);
                $QualifierId = NULL;
            }
        }
    }
}

# ----- MAIN -----------------------------------------------------------------

# non-standard global variables
global $ErrorMessages;
global $F_NewName;
global $F_NewNamespace;
global $F_NewUrl;
global $_POST;

if (!CheckAuthorization(PRIV_SYSADMIN, PRIV_COLLECTIONADMIN)) {  return;  }

# grab entry information from database
$DB = new Database();

if (isset($_POST["F_NewName"]))
    $F_NewName = $_POST["F_NewName"];
if (isset($_POST["F_NewName"]))
    $F_NewNamespace = $_POST["F_NewNamespace"];
if (isset($_POST["F_NewUrl"]))
    $F_NewUrl = $_POST["F_NewUrl"];
if (isset($_POST["OkayToDelete"]))
    $OkayToDelete = $_POST["OkayToDelete"];
else
    $OkayToDelete = NULL;
if (isset($_POST["Submit"]))
    $Submit = $_POST["Submit"];
else
    $Submit = NULL;

$ErrorMessages = array();

# check for Cancel button from previous screen
if ($Submit == "Cancel")
{
    # cancel from confirm delete
    if ($OkayToDelete)
        $AF->SetJumpToPage("AddQualifier");
    else
        $AF->SetJumpToPage("SysAdmin");
    return;
}
else if (substr($Submit, 0, 6) == "Delete")
{
    if ($OkayToDelete)
    {
        RemoveListValue();
    }
    # give user a second chance
    else
    {
        $Qualifiers = GetRemoveList();
        if (count($Qualifiers) > 0)
        {
            $Session->PassVariable("Qualifiers", $Qualifiers);
            $AF->SetJumpToPage("ConfirmDeleteQualifier");
            return;
        }
        else
            $ErrorMessages[] = "<b>Error: </b>No Qualifiers selected";

    }
}
else if (substr($Submit, 0, 15) == "Update Selected")
{
    UpdateListValue();
}
else if (substr($Submit, 0, 3) == "Add" ||
    (empty($Submit) && isset($F_NewName)))
{
    AddListValue();
}

$Session->PassVariable("ErrorMessages");
$AF->SetJumpToPage("AddQualifier");

?>
