<?PHP

#
#   FILE:  SPT--UpdateForum.php
#
#   FUNCTIONS PROVIDED:
#
#   FUNCTIONS EXPECTED:
#
#   Part of the Scout Portal Toolkit
#   Copyright 2004 Internet Scout Project
#   http://scout.cs.wisc.edu
#

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

# ----- LOCAL FUNCTIONS ------------------------------------------------------

# remove selected forum
function RemoveForum()
{
    if (isset($_POST["F_ForumId"]))
        $F_ForumId = $_POST["F_ForumId"];
    elseif (isset($_SESSION["F_ForumId"]))
        $F_ForumId = $_SESSION["F_ForumId"];

    if ( isset($F_ForumId))
    {
        $Forum = new Forum($F_ForumId);
        $Forum->Delete();
    }
}

# add new forum
function AddForum()
{
    global $F_ForumName, $F_ForumDescription, $F_ForumModeratorId, $AF;

    if (isset($_POST["F_ForumName"]))
        $F_ForumName = $_POST["F_ForumName"];
    elseif (isset ($_SESSION["F_ForumName"]))
        $F_ForumName = $_SESSION["F_ForumName"];

    if (isset($_POST["F_ForumDescription"]))
        $F_ForumDescription = $_POST["F_ForumDescription"];
    elseif (isset($_SESSION["F_ForumDescription"]))
        $F_ForumDescription = $_SESSION["F_ForumDescription"];

    # Trim whitespace
    $F_ForumName = trim($F_ForumName);
    $F_ForumDescription = trim($F_ForumDescription);

    # make sure not empty strings
    if ( isset($F_ForumName) && isset ($F_ForumDescription) &&
         strlen($F_ForumName) && strlen($F_ForumDescription))
    {
        $Forum = new Forum();
        $Forum->ForumName($F_ForumName);
        $Forum->ForumDescription($F_ForumDescription);
        $Forum->TopicCount("0");
        $Forum->MessageCount("0");
        $Forum->ModeratorId($F_ForumModeratorId);
    }
    else
    {
        $ErrorMessages[] =
            "Error: Forum name and description are required fields.";
        $_SESSION["ErrorMessages"] = $ErrorMessages;
    }
}

# edit selected forum
function EditForum()
{
    global $F_ForumId;

    $Forum = new Forum($F_ForumId);
    $_SESSION["F_ForumId"] = $F_ForumId;
    $_SESSION["F_ForumDescription"] = $Forum->ForumDescription();
    $_SESSION["F_ForumName"] = $Forum->ForumName();
    $_SESSION["Edit"] = 1;
}

# update selected forum
function UpdateForum()
{
    global $F_ForumId, $F_ForumModeratorId;

    if (isset($_POST["F_ForumName"]))
        $F_ForumName = $_POST["F_ForumName"];
    elseif (isset($_SESSION["F_ForumName"]))
        $F_ForumName = $_SESSION["F_ForumName"];

    if (isset($_POST["F_ForumDescription"]))
        $F_ForumDescription = $_POST["F_ForumDescription"];
    elseif (isset($_SESSION["F_ForumDescription"]))
        $F_ForumDescription = $_SESSION["F_ForumDescription"];

    $Forum = new Forum($F_ForumId);
    $Forum->ForumName($F_ForumName);
    $Forum->ForumDescription($F_ForumDescription);
    $Forum->ModeratorId($F_ForumModeratorId);

    foreach (array("F_ForumId", "F_ForumName", "F_ForumDescription",
                   "F_ForumModeratorId", "Edit") as $Var )
        if (isset($_SESSION[$Var]))
            unset($_SESSION[$Var]);
}

# ----- MAIN -----------------------------------------------------------------

# non-standard global variables
global $F_ForumDescription;
global $F_ForumId;
global $F_ForumModeratorId;
global $F_ForumName;

if (!CheckAuthorization(PRIV_SYSADMIN, PRIV_USERADMIN)) {  return;  }

if (isset($_POST["Submit"]))
    $Submit = $_POST["Submit"];
else
    $Submit = NULL;

if (isset($_POST["F_ForumId"]))
    $F_ForumId = $_POST["F_ForumId"];
elseif (isset($_SESSION["F_ForumId"]))
    $F_ForumId = $_SESSION["F_ForumId"];

if (isset($_POST["F_ForumModeratorId"]))
    $F_ForumModeratorId = $_POST["F_ForumModeratorId"];
else
    $F_ForumModeratorId = NULL;


# return to add forum page
$AF->SetJumpToPage("AddForum");

if (substr($Submit, 0, 6) == "Remove")
{
    RemoveForum();
    unset($F_ForumId);
}
else if (substr($Submit, 0, 3) == "Add")
{
    AddForum();
}
else if (substr($Submit, 0, 4) == "Edit")
{
    EditForum();
}
else if (substr($Submit, 0, 6) == "Update")
{
    UpdateForum();
}
elseif ($Submit=="Cancel")
{
    $AF->SetJumpToPage("Home");

    foreach (array("F_ForumId", "F_ForumName", "F_ForumDescription",
                   "F_ForumModeratorId", "Edit") as $Var )
        if (isset($_SESSION[$Var]))
            unset($_SESSION[$Var]);
}

?>
