<?PHP
#
#   FILE:  PreviewMessage.php
#
#   FUNCTIONS PROVIDED:
#
#   FUNCTIONS EXPECTED:
#       DisplayAddButtons()
#           - display add, delete, cancel buttons
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2012 Internet Scout Project
#   http://scout.wisc.edu/
#

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

function PrintHeading()
{
    global $Message;

    if ($Message)
        print "Preview Message";
    else
        print "Preview Topic and Message";
}

function PrintSubmitButton()
{
    global $Message;

    if ($Message)
        print "Post New Message";
    else
        print "Add New Topic and Message";

}

function PrintEditButton()
{
    global $Message;

    if ($Message)
        print "Edit Message";
    else
        print "Edit Topic and Message";

}

function PrintForumId()
{
    global $F_ForumId;

    print $F_ForumId;
}

function PrintParentId()
{
    global $Session;

    $ParentId = $Session->Get("ParentId");

    print $ParentId;
}

function PrintForumName()
{
    global $ForumName;

    print StripXSSThreats(stripslashes($ForumName));
}

function PrintTopic()
{
    global $F_TopicName;

    print StripXSSThreats(stripslashes($F_TopicName));
}

function PrintBody()
{
    global $F_Body;

    print nl2br(defaulthtmlentities(stripslashes($F_Body)));
}

function PrintSubject()
{
    global $F_Subject;

    print defaulthtmlentities(stripslashes($F_Subject));
}

# ----- LOCAL FUNCTIONS ------------------------------------------------------

# ----- MAIN -----------------------------------------------------------------

# non-standard global variables
global $F_Body;
global $F_ForumId;
global $F_Subject;
global $F_TopicName;
global $ForumName;
global $Message;

if (isset($_SESSION["ForumId"]))
    $F_ForumId = $_SESSION["ForumId"];

if (isset($F_ForumId))
    $Forum = new Forum($F_ForumId);

$ForumName = $Forum->ForumName();
$ModeratorId = $Forum->ModeratorId();

if (isset($_SESSION["Message"]))
    $Message = $_SESSION["Message"];
if (isset($_SESSION["ParentId"]))
    $ParentId = $_SESSION["ParentId"];
if (isset($_SESSION["F_Subject"]))
    $F_Subject = $_SESSION["F_Subject"];
if (isset($_SESSION["F_Body"]))
    $F_Body = $_SESSION["F_Body"];
if (isset($_SESSION["F_TopicName"]))
    $F_TopicName = $_SESSION["F_TopicName"];

PageTitle("Preview Message");
