<?PHP

#
#   FILE:  SavedSearchFactory.php
#
#   Part of the Collection Workflow Integration System
#   Copyright 2009 Edward Almasy and Internet Scout
#   http://scout.wisc.edu
#

/**
* Factory for manipulating saved search objects.
*/
class SavedSearchFactory extends ItemFactory {

    # ---- PUBLIC INTERFACE --------------------------------------------------

    # object constructor
    public function __construct()
    {
        # set up item factory base class
        $this->ItemFactory("SavedSearch", "SavedSearches", "SearchId", "SearchName");
    }

    public function GetSearchesForUser($UserId)
    {
        # start with empty list of searches
        $Searches = array();
    
        # retrieve all IDs for user
        $this->DB->Query("SELECT SearchId FROM SavedSearches WHERE UserId = '"
                .intval($UserId)."'");
        $SearchIds = $this->DB->FetchColumn("SearchId");
    
        # for each search ID
        foreach ($SearchIds as $SearchId)
        {
            # add search to list
            $Searches[$SearchId] = new SavedSearch($SearchId);
        }
    
        # return list of searches to caller
        return $Searches;
    }
    
    # retrieve all searches that should be run according to frequency and last run time
    function GetSearchesDueToRun()
    {
        # start with empty list of searches
        $Searches = array();
    
        # retrieve searches with frequency/time values that indicate need to be run 
        $this->DB->Query("SELECT SearchId FROM SavedSearches"
                ." WHERE ((Frequency = ".SavedSearch::SEARCHFREQ_HOURLY.")"
                        ." AND (DateLastRun < '"
                        .date("Y-m-d H:i:s", (strtotime("1 hour ago") + 15))."'))"
                ." OR ((Frequency = ".SavedSearch::SEARCHFREQ_DAILY.")"
                        ." AND (DateLastRun < '"
                        .date("Y-m-d H:i:s", (strtotime("1 day ago") + 15))."'))"
                ." OR ((Frequency = ".SavedSearch::SEARCHFREQ_WEEKLY.")"
                        ." AND (DateLastRun < '"
                        .date("Y-m-d H:i:s", (strtotime("1 week ago") + 15))."'))"
                ." OR ((Frequency = ".SavedSearch::SEARCHFREQ_BIWEEKLY.")"
                        ." AND (DateLastRun < '"
                        .date("Y-m-d H:i:s", (strtotime("2 weeks ago") + 15))."'))"
                ." OR ((Frequency = ".SavedSearch::SEARCHFREQ_MONTHLY.")"
                        ." AND (DateLastRun < '"
                        .date("Y-m-d H:i:s", (strtotime("1 month ago") + 15))."'))"
                ." OR ((Frequency = ".SavedSearch::SEARCHFREQ_QUARTERLY.")"
                        ." AND (DateLastRun < '"
                        .date("Y-m-d H:i:s", (strtotime("3 months ago") + 15))."'))"
                ." OR ((Frequency = ".SavedSearch::SEARCHFREQ_YEARLY.")"
                        ." AND (DateLastRun < '"
                        .date("Y-m-d H:i:s", (strtotime("1 year ago") + 15))."'))");
        $SearchIds = $this->DB->FetchColumn("SearchId");
    
        # for each search ID
        foreach ($SearchIds as $SearchId)
        {
            # add search to list
            $Searches[$SearchId] = new SavedSearch($SearchId);
        }
    
        # return list of searches to caller
        return $Searches;
    }

    function GetSearchCount()
    {
        return $this->DB->Query(
                "SELECT COUNT(*) AS SearchCount FROM SavedSearches", "SearchCount");
    }

    function GetSearchUserCount()
    {
        return $this->DB->Query(
                "SELECT COUNT(DISTINCT UserId) AS UserCount FROM SavedSearches", 
                "UserCount");
    }


    # ---- PRIVATE INTERFACE -------------------------------------------------

}


?>
