-- add metadata field table changes
ALTER TABLE MetadataFields ADD COLUMN UserPrivilegeRestrictions TEXT;
ALTER TABLE MetadataFields ADD COLUMN ViewingUserIsValue INT DEFAULT 0;
ALTER TABLE MetadataFields ADD COLUMN AuthoringUserIsValue INT DEFAULT 0;
ALTER TABLE MetadataFields ADD COLUMN EditingUserIsValue INT DEFAULT 0;
ALTER TABLE MetadataFields ADD COLUMN ViewingUserValue INT DEFAULT 0;
ALTER TABLE MetadataFields ADD COLUMN AuthoringUserValue INT DEFAULT 0;
ALTER TABLE MetadataFields ADD COLUMN EditingUserValue INT DEFAULT 0;

-- Add timestamp tracking
CREATE TABLE IF NOT EXISTS ResourceFieldTimestamps (
        ResourceId      INT NOT NULL,
        FieldId         INT NOT NULL,
        Timestamp       DATETIME,
        ModifiedBy      INT NOT NULL,
        INDEX           (ResourceId, FieldId),
        INDEX           (Timestamp)
);

-- Be sure that the autoupdate settings are correct:
UPDATE MetadataFields SET UpdateMethod="OnRecordCreate"
  WHERE FieldName="Date of Record Creation";

UPDATE MetadataFields SET UpdateMethod="OnRecordChange"
  WHERE FieldName="Date Last Modified";

