<?PHP
#
#   FILE:  AddResourceComment.php
#
#   FUNCTIONS PROVIDED:
#       IsEditing
#
#   FUNCTIONS EXPECTED:
#       (none)
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2012 Internet Scout Project
#   http://scout.wisc.edu/
#

require_once("lib/AxisPHP/Axis--StandardLibrary.php");

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

function IsEditing()
{
    global $Message, $User;
    return isset($Message) && ($User->Id() == $Message->PosterId()
           || $User->HasPriv(PRIV_SYSADMIN));
}

function GetBody()
{
    global $Message;

    if (!isset($Message) && !isset($_SESSION["F_Body"]) )
    {
        return "";
    }

    if (!isset($Message) && isset($_SESSION["F_Body"] ) )
    {
        $Body = GetFromSession("F_Body");
        return defaulthtmlentities($Body);
    }

    return defaulthtmlentities($Message->Body());
}

function GetFromSession($VarName){
    $Value = NULL;
    if (isset($_SESSION[$VarName]))
    {
        $Value = $_SESSION[$VarName];
        unset ($_SESSION[$VarName]);
    }
    return $Value;
}

/**
 * THIS FUNCTION IS DEPRECATED
 */
function PrintTitle()
{
    global $User, $Resource;

    $TitleField = $Schema->GetFieldByMappedName("Title");
    if ($Resource->UserCanViewField($User, $TitleField))
    {
        print strip_tags($Resource->Get($TitleField),
            "<b><i><u><sub><sup><strike><a>");
    }
}

/**
 * THIS FUNCTION IS DEPRECATED
 */
function PrintSubject()
{
    global $Message;

    print defaulthtmlentities($Message->Subject());
}

/**
 * THIS FUNCTION IS DEPRECATED
 */
function PrintBody()
{
    global $Message;

    print defaulthtmlentities($Message->Body());
}

/**
 * THIS FUNCTION IS DEPRECATED
 */
function PrintErrorMessages() { }

/**
 * THIS FUNCTION IS DEPRECATED
 */
function CheckForEdit()
{
    global $Message, $User;

    return isset($Message) && ($User->Id() == $Message->PosterId()
                                 || $User->HasPriv(PRIV_SYSADMIN));
}

# ----- LOCAL FUNCTIONS ------------------------------------------------------

# ----- MAIN -----------------------------------------------------------------

global $Message;
global $Resource;
global $TitleField;
global $ErrorMessages;

if (!CheckAuthorization(PRIV_SYSADMIN, PRIV_POSTCOMMENTS)) {  return;  }

$Schema = new MetadataSchema();
$TitleField = $Schema->GetFieldByMappedName("Title");

# do the query for this resource
if (isset($_GET["ResourceId"]))
{
    $Resource = new Resource($_GET["ResourceId"]);
}
else if ( isset($_SESSION["ResourceId"] ))
{
    $ResourceId = GetFromSession("ResourceId");
    $Resource = new Resource($ResourceId);
}

if (!isset($Resource) || $Resource->Status() != 1)
{
    $AF->SetJumpToPage("Home");
    return;
}

if (isset($_GET["MessageId"]))
{
    $Message = new Message($_GET["MessageId"]);
}

else if ( isset($_SESSION["MessageId"] ) )
{
    $MessageId = GetFromSession("MessageId");
    $Message = new Message($MessageId);
}

if (isset($_SESSION["ErrorMessages"]))
    $ErrorMessages = GetFromSession("ErrorMessages");

if (IsEditing())
{
    PageTitle("Update Resource Comment");
}
# or adding
else
{
    PageTitle("Add Resource Comment");
}

# pass along necessary variables
$_SESSION["ResourceId"] = $Resource->Id();
$_SESSION["ParentId"]   = $Resource->Id();

if (isset($Message) )
{
    $_SESSION["F_Subject"] = $Message->Subject();
    $_SESSION["MessageId"] = $Message->MessageId();
}
else
{
    $_SESSION["F_Subject"] = "Comment On: ".$Resource->GetMapped("Title");
}
