<?PHP
#
#   FILE:  ConfigSettingsUI.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2014 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

/**
* Class supplying a standard user interface for viewing and setting
* configuration parameters.
*/
class ConfigSettingsUI extends FormUI
{

    # ---- PUBLIC INTERFACE --------------------------------------------------

    /**
    * Display HTML table with settings parameters.
    * @param string $TableId CSS ID for table element.  (OPTIONAL)
    * @param string $TableStyle CSS styles for table element.  (OPTIONAL)
    */
    public function DisplaySettingsTable($TableId = NULL, $TableStyle = NULL)
    {
        $this->DisplayFormTable($TableId, $TableStyle);
    }

    /**
    * Retrieve values set by form.
    * @return array Array of configuration settings, with setting names
    *       for the index, and new setting values for the values.
    */
    public function GetNewSettingsFromForm()
    {
        return $this->GetNewValuesFromForm();
    }


    # ---- PRIVATE INTERFACE -------------------------------------------------
}
