<?PHP
#
#   FILE:  PluginUninstall.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2012-2013 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

# ----- MAIN -----------------------------------------------------------------

PageTitle("Plugin Uninstall");

# check that the user has sufficient privileges
if (!CheckAuthorization(PRIV_SYSADMIN)) {  return;  }

$PluginName = isset($_GET["PN"]) ? $_GET["PN"] : NULL;
$G_Plugin = $G_PluginManager->GetPlugin($PluginName, TRUE);
$H_UninstallFailed = FALSE;
$H_UninstallResult = NULL;

# if specified plugin was found and action was requested
if ($G_Plugin && isset($_POST["Submit"]))
{
    # if uninstall was confirmed
    if (($_POST["Submit"] == "Uninstall"))
    {
        # disable plugins that depend on this one
        $Dependents = $G_PluginManager->GetDependents($PluginName);
        foreach ($Dependents as $DependentName)
        {
            $G_PluginManager->PluginEnabled($DependentName, FALSE);
        }

        # uninstall plugin
        $H_UninstallResult = $G_PluginManager->UninstallPlugin($PluginName);

        # failed to uninstall the plugin
        if (!is_null($H_UninstallResult))
        {
            $H_UninstallFailed = TRUE;
            return;
        }

        # force a reload to the plugin list
        # (to avoid issues caused by hooks hanging around from uninstalled
        #       or disabled plugins)
        ?><html>
        <head>
            <meta http-equiv="refresh" content="0; URL=index.php?P=Plugins">
        </head>
        <body bgcolor="white">
        </body>
        </html><?PHP
        exit(0);
    }
    else
    {
        # go back to plugin list
        $AF->SetJumpToPage("Plugins");
    }
}
else
{
    # if specified plugin was found
    if ($G_Plugin)
    {
        # load list of enabled plugins that depend on this one
        $G_Dependents = $G_PluginManager->GetDependents($PluginName);
        foreach ($G_Dependents as $Index => $Dependent)
        {
            if (!$G_PluginManager->PluginEnabled($Dependent))
            {
                unset($G_Dependents[$Index]);
            }
        }
    }
}
