/*
#   Common functions
#
#   FUNCTIONS PROVIDED:
#       HideElement(Element, Id)
#           - Sets display to none of Element or the element with an id of Id, if set.
#             Also sets display attribute.
#       ShowElement(Element, Id)
#           - Sets display to block or of display attribute of Element or element with
#             id of Id
#   Part of the Scout Portal Toolkit and based off
#       functions originally created by Tim Baumgard
#   Copyright 2004 Internet Scout Project
#   http://scout.wisc.edu
*/

function HideElement(Element, Id){
    // Sets Id to false if not set
    Id = Id || false;

    // If an Id was passed instead of an element
    if (Id === true || !Element.nodeName){
        Element = new GetElement(Element);
    }

    // If the element isn't shown, exit
    if (Element.style.display == 'none'){
        return;
    }

    // Gets the current style attribute and sets it as an attribute
    Element.setAttribute("display", Element.style.display);

    // Hide the element
    Element.style.display = "none";
}

function ShowElement(Element, Id){
    // Sets Id to false if not set
    Id = Id || false;

    // If an Id was passed instead of an element
    if (Id === true || !Element.nodeName){
        Element = new GetElement(Element);
    }

    // If the element isn't hidden, exit
    if (Element.style.display != 'none'){
        return;
    }

    // Gets any possible past display settings
    var Display = Element.getAttribute("display") ?
        Element.getAttribute("display") : 'block';

    // Show the element, using past display attribute if necessary
    if (Display === undefined || Display === ''){
        Element.style.display = 'block';
    } else{
        Element.style.display = Display;
    }
}

/*
#   Common DOM functions
#
#   FUNCTIONS PROVIDED:
#       GetElement(ElementName)
#           - Gets the element with id of ElementName
#   Part of the Scout Portal Toolkit and based off
#       functions originally created by Tim Baumgard
#   Copyright 2004 Internet Scout Project
#   http://scout.wisc.edu
*/
function GetElement(ElementName){
    // Depending on the broswer, return the element
    if (document.getElementById){
        return document.getElementById(ElementName);
    } else if (document.all){
        return document.all[ElementName];
    } else if (document.layers){
        return documet.layers[ElementName];
    }
}
