<?PHP
#
#   FILE:  Hide.php (UrlChecker plugin)
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2011-2016 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

PageTitle("Hiding an URL in the URL Checker...");
CheckAuthorization(PRIV_SYSADMIN, PRIV_COLLECTIONADMIN);

$ResourceId = GetFormValue("ResourceId");
$FieldId = GetFormValue("FieldId");

if (Resource::ItemExists($ResourceId))
{
    $Resource = new Resource($ResourceId);
    $Field = $Resource->Schema()->GetField($FieldId);

    if ($Field->Status() == MetadataSchema::MDFSTAT_OK)
    {
        $AF->SignalEvent("URLCHECKER_HIDE_URL", array($Resource, $Field));
    }
}

$GLOBALS["AF"]->SetJumpToPage("P_UrlChecker_Results");
