<?PHP
#
#   FILE:  UpdateResourceNote.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2012 Internet Scout Project
#   http://scout.wisc.edu/
#

# ----- MAIN -----------------------------------------------------------------

# check authorization and setup HTML suppression and page redirection
if (!Folders_Common::ApiPageCompletion("P_Folders_ManageFolders"))
{
    return;
}

# canceled editing
if (GetFormValue("Cancel"))
{
    return;
}

$FolderId = GetFormValue("FolderId");
$ItemId = GetFormValue("ItemId");
$ResourceNote = GetFormValue("ResourceNote");

# can't do anything if there aren't IDs to work with
if (!strlen($FolderId) || !strlen($ItemId))
{
    return;
}

$FolderFactory = new Folders_FolderFactory($User->Id());
$ResourceFolder = $FolderFactory->GetResourceFolder();

try
{
    $Folder = new Folders_Folder($FolderId);

    # withdraw only if the resource folder contains this folder, which implies
    # that the user owns the folder and it's a valid folder of resources
    if ($ResourceFolder->ContainsItem($FolderId))
    {
        # make sure the resource is valid and the folder contains it
        if (Resource::ItemExists($ItemId) && $Folder->ContainsItem($ItemId))
        {
            $Folder->NoteForItem($ItemId, $ResourceNote);
        }
    }
} catch (Exception $Exception) {
    # do nothing if bad folder ID
}

