<?PHP
#
#   FILE:  EventReports.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2014 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

# ----- LOCAL FUNCTIONS ------------------------------------------------------

# Helper function to deal with data summary arrays:
function CreateOrIncrement(&$Array, $Key)
{
    if (!isset($Array[$Key]))
        $Array[$Key] = 1;
    else
        $Array[$Key]++;
}


# ----- MAIN -----------------------------------------------------------------

PageTitle("Event Usage Metrics");

# make sure user has sufficient permission to view report
if (!CheckAuthorization(PRIV_COLLECTIONADMIN)) {  return;  }

# Check to be sure that the CalendarEvents plugin is actually enabled before doing other things.
if (!$GLOBALS["G_PluginManager"]->PluginEnabled("CalendarEvents") ){
    CheckAuthorization(-1);
    return;
}


# Grab ahold of the relevant metrics objects:
$Recorder = $GLOBALS["G_PluginManager"]->GetPlugin("MetricsRecorder");
$Reporter = $GLOBALS["G_PluginManager"]->GetPlugin("MetricsReporter");

$CalendarEvents = $GLOBALS["G_PluginManager"]->GetPlugin("CalendarEvents");

$Now = time();

$Past = array(
    "Week"  => $Now -   7 * 86400,
    "Month" => $Now -  30 * 86400,
    "Year" => $Now - 365 * 86400
);

$H_WeekAgo  = date('Y-m-d', $Past["Week"]);
$H_MonthAgo = date('Y-m-d', $Past["Month"]);
$H_YearAgo  = date('Y-m-d', $Past["Year"]);

#
# New events per day
#
$DB = new Database();
$DB->Query(
    "SELECT DATE(DateofCreation".$CalendarEvents->GetSchemaId().") AS D,"
    ." COUNT(*) AS CNT FROM Resources"
    ." WHERE SchemaId=".$CalendarEvents->GetSchemaId()
    ." GROUP BY D");

$EventsPerDay = array();
while ($Row = $DB->FetchRow())
{
    $TS = strtotime( $Row["D"]);
    $EventsPerDay[ $TS ] = array($Row["CNT"]);
}

$H_EventsPerDay = new Graph(Graph::TYPE_DATE_BAR, $EventsPerDay);
$H_EventsPerDay->XLabel("Date");
$H_EventsPerDay->YLabel("New Events per Day");

#
# Event Views per day
#
$ViewsData = array();
$H_ViewData = array(
    "Week" => array(),
    "Month" => array(),
    "Year" => array() );

foreach ($Recorder->GetEventData(
             "CalendarEvents", "ViewEvent",
             NULL, NULL, NULL,
             NULL, NULL, $Reporter->ConfigSetting("PrivsToExcludeFromCounts"),
             0, NULL) as $Event)
{
    $TS = strtotime($Event["EventDate"]);
    $ViewsData[$TS] = array(1);

    foreach (array("Week","Month","Year") as $Period)
    {
        if ($Past[$Period] < $TS)
            CreateOrIncrement($H_ViewData[$Period], $Event["DataOne"]);
    }
}

$H_ViewsPerDay = new Graph(Graph::TYPE_DATE_BAR, $ViewsData);
$H_ViewsPerDay->XLabel("Date");
$H_ViewsPerDay->YLabel("Event Views");

#
# Event shares per day
#

# Get a list of all the Resources that are also events
# Use that to filter the shares data

$EventFactory = new ResourceFactory( $CalendarEvents->GetSchemaId() );

$EventIds = array();
foreach ($EventFactory->GetItemIds() as $EventId)
    $EventIds[ $EventId ] = 1;

$SharesData = array();
$H_ShareData = array(
    "Week" => array(),
    "Month" => array(),
    "Year" => array() );

$ShareTypeMap = array(
    SocialMedia::SITE_EMAIL => 0,
    SocialMedia::SITE_FACEBOOK => 1,
    SocialMedia::SITE_TWITTER => 2,
    SocialMedia::SITE_LINKEDIN => 3,
    SocialMedia::SITE_GOOGLEPLUS => 4
    );

foreach ($Recorder->GetEventData(
             "SocialMedia", "ShareResource",
             NULL, NULL, NULL,
             NULL, NULL, $Reporter->ConfigSetting("PrivsToExcludeFromCounts"),
             0, NULL) as $Event)
{
    # Skip non-event shares:
    if (!isset($EventIds[ $Event["DataOne"] ] ))
        continue;

    $TS =  strtotime($Event["EventDate"]);

    $SharesData[$TS] = array(0, 0, 0, 0, 0);
    $SharesData[$TS][ $ShareTypeMap[ $Event["DataTwo"]]] = 1;

    foreach (array("Week","Month","Year") as $Period)
    {
        if ($Past[$Period] < $TS)
            CreateOrIncrement( $H_ShareData[$Period], $Event["DataOne"]);
    }

}

$H_SharesPerDay = new Graph(Graph::TYPE_DATE_BAR, $SharesData);
$H_SharesPerDay->XLabel("Date");
$H_SharesPerDay->YLabel("Event Shares");
$H_SharesPerDay->Legend( array("Email", "Facebook", "Twitter", "LinkedIn", "GooglePlus") );
$H_SharesPerDay->Scale( Graph::WEEKLY );

#
# Most viewed and shared events
#

foreach (array("Week", "Month", "Year") as $Period)
{
    arsort($H_ViewData[$Period]);
    arsort($H_ShareData[$Period]);
}
