<?PHP
#
#   FILE:  MetadataFieldGroup.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2012-2016 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

/**
* Class that builds on the foldering functionality to provide groups of
* metadata fields.
*/
class MetadataFieldGroup extends Folder
{

    /**
    * Get the items of the metadata field group as objects instead of IDs.
    * @return Returns an array of metadata field objects.
    */
    public function GetFields()
    {
        $ItemIds = $this->GetItemIds();
        $Items = array();

        foreach ($ItemIds as $Info)
        {
            try
            {
                $Items[] = new $Info["Type"]($Info["ID"]);
            }

            # skip invalid fields
            catch (InvalidArgumentException $Exception)
            {
                continue;
            }
        }

        return $Items;
    }

    /**
    * Get the number of metadata fields this group holds.
    * @return Returns the number of metadata fields this group holds.
    */
    public function GetFieldCount()
    {
        if (!isset($this->FieldCount))
        {
            $this->FieldCount = count($this->GetItemIds());
        }

        return $this->FieldCount;
    }

    /**
    * The number of metadata fields the group contains.
    */
    protected $FieldCount;
}

