<?PHP
#
#   FILE:  ListPages.php (Pages plugin)
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2012-2016 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis
#

# check authorization to see page list
$Plugin = $GLOBALS["G_PluginManager"]->GetPluginForCurrentPage();
$H_SchemaId = $Plugin->ConfigSetting("MetadataSchemaId");
$Schema = new MetadataSchema($H_SchemaId);
if (!$Schema->UserCanAuthor($GLOBALS["G_User"])
        && !$Schema->UserCanEdit($GLOBALS["G_User"]))
{
    DisplayUnauthorizedAccessPage();
    return;
}

# retrieve sort parameters from URL
$DefaultSortFieldId = $Schema->GetFieldIdByName("Date Last Modified");
$SortFieldId = GetFormValue(TransportControlsUI::PNAME_SORTFIELD, $DefaultSortFieldId);
$SortField = $Schema->GetField($Schema->FieldExists($SortFieldId)
        ? $SortFieldId : $DefaultSortFieldId);
$ReverseSort = GetFormValue(TransportControlsUI::PNAME_REVERSESORT, FALSE);

# determine list sort direction
if ($SortFieldId == $DefaultSortFieldId)
{
    $SortAscending = $ReverseSort ? TRUE : FALSE;
}
else
{
    $SortAscending = $ReverseSort ? FALSE : TRUE;
}

# load page IDs
$PFactory = new Pages_PageFactory();
$PageIds = $PFactory->GetItemIds(
        NULL, FALSE, $SortField->DBFieldName(), $SortAscending);

# get total count of pages
$H_PageCount = count($PageIds);

# get where we currently are in page list
$H_StartingIndex = GetFormValue(TransportControlsUI::PNAME_STARTINGINDEX, 0);

# calculate ID array checksum and reset paging if list has changed
$H_ListChecksum = md5(serialize($PageIds));
if ($H_ListChecksum != GetFormValue("CK")) {  $H_StartingIndex = 0;  }

# prune page IDs down to just currently-selected segment
$H_PagesPerPage = 25;
$PageIds = array_slice($PageIds, $H_StartingIndex, $H_PagesPerPage);

# load pages from page IDs
$H_Pages = array();
foreach ($PageIds as $Id)
{
    $H_Pages[$Id] = new Pages_Page($Id);
}

