<?PHP
#
#   FILE:  MessageFactory.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2011-2016 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

/**
* Factory for forum messages / resource comments.
* \nosubgrouping
*/
class MessageFactory extends ItemFactory
{
    # ---- PUBLIC INTERFACE --------------------------------------------------

    /** @name Setup/Initialization */
    /*@{*/

    /**
    * Object constructor.
    */
    public function __construct()
    {
        parent::__construct("Message", "Messages", "MessageId", "Subject");
    }

    /*@}*/

    /** @name Accessors */
    /*@{*/

    /**
    * Get all messages posted by specified user, in reverse date order.
    * @param int $UserId ID of user.
    * @param int $Count Number of messages to retrieve.  (OPTIONAL)
    * @return array Array of Message objectss.
    */
    public function GetMessagesPostedByUser($UserId, $Count = NULL)
    {
        # retrieve message IDs posted by specified user
        $this->DB->Query("SELECT MessageId FROM Messages"
                ." WHERE PosterId = ".intval($UserId)
                ." ORDER BY DatePosted DESC"
                .($Count ? " LIMIT ".intval($Count) : ""));
        $MessageIds = $this->DB->FetchColumn("MessageId");

        # load messages based on message IDs
        $Messages = array();
        foreach ($MessageIds as $Id)
        {
            $Messages[$Id] = new Message($Id);
        }

        # return array of message IDs to caller
        return $Messages;
    }

    /*@}*/

    # ---- PRIVATE INTERFACE -------------------------------------------------
}

