<?PHP
#
#   FILE:  OAIItem.php

#
#   Part of the ScoutLib application support library
#   Copyright 2009-2016 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu
#

interface OAIItem
{
    /**
    * Get item id.
    * @return int ItemId.
    */
    public function GetId();

    /**
    * Get datestamp for item.
    * @return string Datestamp.
    */
    public function GetDatestamp();

    /**
    * Get value for a specified Element of an Item.
    * @param string $ElementName Element to fetch.
    * @return string Requested value
    */
    public function GetValue($ElementName);

    /**
    * Get qualifier for a specified Element of an Item.
    * @param string $ElementName Element to fetch.
    * @return string Requested qualifier.
    */
    public function GetQualifier($ElementName);

    /**
    * Get OAI sets an item belongs to.
    * @return array List of sets.
    */
    public function GetSets();

    /**
    * Get search information for item.
    * @return array Search info.
    */
    public function GetSearchInfo();

    /**
    * Get item status.
    * @return int Item status.
    */
    public function Status();
}
