(function(window){
  var basePath = getBasePath(window),
      css = [];

  // can't continue if the CKEDITOR variable isn't available
  if (typeof CKEDITOR === "undefined") {
    return;
  }

  // CWIS theme styles
  // note: this relys on CKEditorSetup.php to set up the correct variable
  if (typeof CWIS_THEME_STYLE !== "undefined") {
    css.push(CWIS_THEME_STYLE);
  }

  // custom theme styles
  if (typeof CWIS_CKEDITOR_OVERRIDE !== "undefined") {
    css.push(basePath + CWIS_CKEDITOR_OVERRIDE);
  }

  // default CKEditor fixes
  // note: this relys on CKEditorSetup.php to set up the correct variable
  if (typeof CWIS_CKEDITOR_STYLE !== "undefined") {
    css.push(CWIS_CKEDITOR_STYLE);
  }

  // custom theme fixes
  if (typeof CWIS_CKEDITOR_FIXES !== "undefined") {
    css.push(basePath + CWIS_CKEDITOR_FIXES);
  }

  // hand the array of CSS files to CKEditor
  CKEDITOR.config.contentsCss = css;

  // create the default toolbar
  CKEDITOR.config.toolbar_CwisDefault = [
    ['Styles'],
    ['RemoveFormat'],
    ['Bold', 'Italic', 'Underline', 'Superscript', 'Subscript', 'Strike'],
    ['NumberedList', 'BulletedList', 'Blockquote'],
    ['JustifyLeft', 'JustifyCenter', 'JustifyRight', 'JustifyBlock'],
    ['Source'],
    ['Maximize'],
    '/',
    ['Undo', 'Redo'],
    ['Cut', 'Copy', '-', 'Paste', 'PasteText', 'PasteFromWord'],
    ['Find', 'Replace', '-', 'SpellChecker'],
    ['Link', 'Unlink', 'Anchor'],
    ['HorizontalRule', 'SpecialChar'],
    ['ShowBlocks', 'CreateDiv']
  ];

  // create the full toolbar, which requires style attributes and image tags
  CKEDITOR.config.toolbar_CwisFull = [
    ['Styles'],
    ['RemoveFormat'],
    ['Bold', 'Italic', 'Underline', 'Superscript', 'Subscript', 'Strike'],
    ['NumberedList', 'BulletedList', 'Blockquote'],
    ['JustifyLeft', 'JustifyCenter', 'JustifyRight', 'JustifyBlock', '-', 'Indent', 'Outdent'],
    ['Source'],
    ['Maximize'],
    '/',
    ['Undo', 'Redo'],
    ['Cut', 'Copy', '-', 'Paste', 'PasteText', 'PasteFromWord'],
    ['Find', 'Replace', '-', 'SpellChecker'],
    ['Link', 'Unlink', 'Anchor'],
    ['Image', 'Table'],
    ['HorizontalRule', 'SpecialChar'],
    ['TextColor', 'BGColor'],
    ['ShowBlocks', 'CreateDiv']
  ];

  // set the styles used by the styles button
  CKEDITOR.config.stylesSet = [
    // block styles
    {"name": "Paragraph", "element": "p"},
    {"name": "Heading 1", "element": "h1"},
    {"name": "Heading 2", "element": "h2"},
    {"name": "Heading 3", "element": "h3"},
    {"name": "Heading 4", "element": "h4"},
    {"name": "Heading 5", "element": "h5"},
    {"name": "Heading 6", "element": "h6"},
    {"name": "Preformatted Text", "element": "pre"},

    // inline styles
    {"name": "Computer Code", "element": "code"}
  ];

  // use the default toolbar
  CKEDITOR.config.toolbar = "CwisDefault";

  // enable SCAYT by default
  CKEDITOR.config.scayt_autoStartup = true;

  function getBasePath(window) {
    var path = window.location.pathname;

    // get the path without the file name
    path = path.replace(/\\/g, "/").replace(/\/[^\/]*\/?$/, "");

    // add trailing slash if one isn't there
    if (path.charAt(path.length) != "/") {
      path += "/";
    }

    return path;
  }

}(window));
