<?PHP
#
#   FILE:  RebuildRecommender.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2013 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

if (!CheckAuthorization(PRIV_SYSADMIN, PRIV_COLLECTIONADMIN)) {  return;  }

if ($_GET["AC"] == "Background")
{
    $Recommender = new SPTRecommender();
    $RFactory = new ResourceFactory();
    $Ids = $RFactory->GetItemIds();
    foreach ($Ids as $Id)
    {
        $Recommender->QueueUpdateForItem((int)$Id,
                ApplicationFramework::PRIORITY_BACKGROUND);
    }
    $GLOBALS["AF"]->QueueUniqueTask(array($Recommender, "PruneCorrelations"),
                array(), ApplicationFramework::PRIORITY_BACKGROUND);
    $GLOBALS["ResourceCount"] = count($Ids);
}

?>
