<?PHP
#
#   FILE:  RegisterPortalComplete.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2004-2013 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

PageTitle("Registration Complete");

# destination for registration info e-mail
$RegInfoRecipient = "register@scout.wisc.edu";


# ----- EXPORTED FUNCTIONS ---------------------------------------------------

# ----- LOCAL FUNCTIONS ------------------------------------------------------

function GetRegistrationMessageContent($UserEnteredVals)
{
    global $SysConfig;
    global $User;
    global $_SERVER;
    global $SPT_SoftwareVersionToDisplay;

    # create XML stream to use in generating content
    $XS = new XMLStream();
    $SchemaInfo = array(
        "xmlns" => "http://scout.wisc.edu/XML/register_v1.0/",
        "xmlns:xsi" => "http://www.w3.org/2001/XMLSchema-instance",
        "xsi:schemaLocation" => "http://scout.wisc.edu/XML/register_v1.0/ "
                ."http://scout.wisc.edu/XML/schemas/register_v1.0.xsd",
        "schemaVersion" => "1.0",
        );
    $XS->OpenElement("registration", $SchemaInfo);

    # retrieve and add general site info
    $XS->AddElement("software", (SoftwareIsCWIS() ? "CWIS" : "SPT")
                    ." ".$SPT_SoftwareVersionToDisplay);
    if ($SysConfig->PortalName())
        { $XS->AddElement("sitename", $SysConfig->PortalName());  }
    $XS->AddElement("siteuri",
            $_SERVER["SERVER_NAME"].dirname($_SERVER["REQUEST_URI"]));
    if ($SysConfig->AdminEmail())
        { $XS->AddElement("adminemail", $SysConfig->AdminEmail());  }
    if ($SysConfig->ContactName())
        { $XS->AddElement("contactname", $SysConfig->ContactName());  }
    if ($SysConfig->ContactEmail())
        { $XS->AddElement("contactemail", $SysConfig->ContactEmail());  }
    if ($SysConfig->Organization())
        { $XS->AddElement("organization", $SysConfig->Organization());  }
    if ($SysConfig->OrganizationType())
        { $XS->AddElement("organizationtype", $SysConfig->OrganizationType());  }
    if ($SysConfig->SiteType()) {  $XS->AddElement("sitetype", $SysConfig->SiteType());  }
    $XS->AddElement("okaytolistsite", ($SysConfig->OkayToListSite() ? "TRUE" : "FALSE"));
    $XS->AddElement("registeringuser", $User->Get("UserName"));

    # retrieve and add configuration settings
    $XS->OpenElement("configuration");
    if ($SysConfig->DefaultActiveUI())
    {
        $XS->AddElement("defaultui", $SysConfig->DefaultActiveUI());
    }
    if ($SysConfig->CurrentTheme())
    {
        $XS->AddElement("currenttheme", $SysConfig->CurrentTheme());
    }
    $XS->OpenElement("toggles");
    $XS->AddElement("forums",
            ($SysConfig->ForumsEnabled() ? "ENABLED" : "DISABLED"));
    $XS->AddElement("useragents",
            ($SysConfig->UserAgentsEnabled() ? "ENABLED" : "DISABLED"));
    $XS->AddElement("announcements",
            ($SysConfig->AnnouncementsEnabled() ? "ENABLED" : "DISABLED"));
    $XS->AddElement("multipleuis",
            ($SysConfig->AllowMultipleUIsEnabled() ? "ENABLED" : "DISABLED"));
    $XS->AddElement("ratings",
            ($SysConfig->ResourceRatingsEnabled() ? "ENABLED" : "DISABLED"));
    $XS->AddElement("comments",
            ($SysConfig->ResourceCommentsEnabled() ? "ENABLED" : "DISABLED"));
    $XS->AddElement("searchupdate",
            ($SysConfig->SearchDBEnabled() ? "ENABLED" : "DISABLED"));
    $XS->AddElement("recommenderupdate",
            ($SysConfig->RecommenderDBEnabled() ? "ENABLED" : "DISABLED"));
    $XS->AddElement("searchlogic", ($SysConfig->SearchTermsRequired() ? "AND" : "OR"));
    $XS->CloseElement();
    $XS->CloseElement();

    # retrieve and add resource DB info
    $XS->OpenElement("datastatistics");
    $RFactory = new ResourceFactory();
    $ResourceCount = $RFactory->GetItemCount();
    $XS->AddElement("resourcecount", $ResourceCount);
    $ReleasedResourceCount = $RFactory->GetItemCount("ReleaseFlag = 1");
    $XS->AddElement("releasedresourcecount", $ReleasedResourceCount);
    $RatedResourceCount = $RFactory->GetRatedResourceCount();
    $XS->AddElement("ratingcount", $RatedResourceCount);

    $ClassFactory = new ClassificationFactory();
    $ClassCount = $ClassFactory->GetItemCount();
    $XS->AddElement("classificationcount", $ClassCount);

    $SampleCount = $RFactory->GetItemCount(
            "INSTR(Description, '[--SAMPLE RECORD--]') > 0");
    $XS->AddElement("sampleresourcecount", $SampleCount);

    $SearchEngine = new SPTSearchEngine();
    $TermCount = $SearchEngine->SearchTermCount();
    $XS->AddElement("searchtermcount", $TermCount);
    $XS->CloseElement();

    # retrieve and add operating environment info
    $XS->OpenElement("environment");
    $XS->AddElement("httpserver", $_SERVER["SERVER_SOFTWARE"]);
    $PhpInfo = GetPhpInfo();
    $XS->AddElement("osstamp", $PhpInfo[""]["System"][0]);
    # (PHP configuration)
    $XS->OpenElement("phpconfig");
    $XS->AddElement("version", phpversion());
    $Settings = array(
            "safe_mode",
            "register_globals",
            "max_execution_time",
            "memory_limit",
            "post_max_size",
            "file_uploads",
            "upload_max_filesize",
            );
    foreach ($Settings as $Setting)
    {
        $Value = ini_get($Setting);
        if (!strlen($Value)) {  $Value = "Off";  }
        if ($Value == "1") {  $Value = "On";  }
        $ElementName = str_replace("_", "", $Setting);
        $XS->AddElement($ElementName, $Value);
    }
    $Val = (isset($PhpInfo["gd"]["GD Version"][0])) ?
            $PhpInfo["gd"]["GD Version"][0] : "unavailable";
    $XS->AddElement("gdversion", $Val);
    $Val = (isset($PhpInfo["gd"]["PNG Support"][0])) ?
            $PhpInfo["gd"]["PNG Support"][0] : "unavailable";
    $XS->AddElement("gdpngsupport", $Val);
    $Val = (isset($PhpInfo["gd"]["JPG Support"][0])) ?
            $PhpInfo["gd"]["JPG Support"][0] : "unavailable";
    $XS->AddElement("gdjpgsupport", $Val);
    $Val = (isset($PhpInfo["gd"]["GIF Support"][0])) ?
            $PhpInfo["gd"]["GIF Support"][0] : "unavailable";
    $XS->AddElement("gdgifsupport", $Val);
    $XS->CloseElement();
    # (MySQL configuration)
    $DB = new Database();
    $XS->OpenElement("mysqlconfig");
    $XS->AddElement("clientversion", $DB->GetClientVersion());
    $XS->AddElement("serverversion", $DB->GetServerVersion());
    $XS->AddElement("connectiontype", $DB->GetHostInfo());
    $XS->CloseElement();
    $XS->CloseElement();

    # add user comments (if any)
    if (strlen($UserEnteredVals["F_Comments"]) > 0)
    {
        $XS->AddElement("comments", $UserEnteredVals["F_Comments"]);
    }

    # retrieve XML from XML stream and return to caller
    $XS->CloseElement();
    return $XS->GetContent();
}

# ----- MAIN -----------------------------------------------------------------

# non-standard global variables
global $SPT_SoftwareVersionToDisplay;
global $_SERVER;

# save any user-entered registration values
if (isset($_POST["F_ContactName"]) && strlen($_POST["F_ContactName"]))
{  $SysConfig->ContactName($_POST["F_ContactName"]);  }
if (isset($_POST["F_ContactEmail"]) && strlen($_POST["F_ContactEmail"]))
{  $SysConfig->ContactEmail($_POST["F_ContactEmail"]);  }
if (isset($_POST["F_Organization"]) && strlen($_POST["F_Organization"]))
{  $SysConfig->Organization($_POST["F_Organization"]);  }
if (isset($_POST["F_OrganizationType"]) &&
    strlen($_POST["F_OrganizationType"]))
{  $SysConfig->OrganizationType($_POST["F_OrganizationType"]);  }
if (isset($_POST["F_SiteType"]) &&strlen($_POST["F_SiteType"]))
{  $SysConfig->SiteType($_POST["F_SiteType"]);  }
$SysConfig->OkayToListSite(isset($_POST["F_OkayToListSite"]) ? 1 : 0);

# generate XML containing registration info
$MsgContent = GetRegistrationMessageContent($_POST);

# e-mail registration info to Scout
$MsgSubject = (SoftwareIsCWIS() ? "CWIS" : "SPT")." Registration";
if ($SysConfig->PortalName() != "Online Resource Portal")
{
    $MsgSubject .= " (".$SysConfig->PortalName().")";
}
else
{
    $MsgSubject .= " (".$_SERVER["SERVER_NAME"].")";
}
$Msg = new Email();
$Msg->To($RegInfoRecipient);
$Msg->From($SysConfig->AdminEmail());
$Msg->Subject($MsgSubject);
$Msg->Body($MsgContent);
$Msg->Send();

# save registration date
$SysConfig->LastRegisteredOn(date("Y-m-d H:i:s"));
