<?PHP

#
#   FILE:  SPT--SPTEventLog.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2007-2013 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

class SPTEventLog extends EventLog {

    # ---- PUBLIC INTERFACE --------------------------------------------------

    # define event types
    const SPTEVENT_USERLOGIN =  1;
    const SPTEVENT_NEWACCOUNTSIGNUP =  2;
    const SPTEVENT_NEWACCOUNTCONFIRM =  3;
    const SPTEVENT_SEARCH =  4;
    const SPTEVENT_ADVANCEDSEARCH =  5;
    const SPTEVENT_RESOURCELINKCLICK =  6;
    const SPTEVENT_OAIHARVEST =  7;

    # define user types
    const SPTUSERTYPE_ALL =  1;
    const SPTUSERTYPE_ANONYMOUS =  2;
    const SPTUSERTYPE_NONPRIVILEGED =  3;
    const SPTUSERTYPE_PRIVILEGED =  4;

    # object constructor
    function __construct()
    {
        # create database for use by our parent
        $DB = new Database();

        # invoke parent constructor
        global $G_User;
        $UserId = $G_User->IsLoggedIn() ? $G_User->Id() : -1;
        parent::__construct($DB, $UserId);
    }

    # limit events to specific user type
    function LimitFindToUserType($UserType)
    {
        # set search conditions based on user type
        switch ($UserType)
        {
            case SPTUSERTYPE_NONPRIVILEGED:
                $this->ExcludeUsersWithPrivileges("<", PRIV_POSTTOFORUMS);
                $this->ExcludeUsersWithPrivileges(">", PRIV_USERDISABLED);
                break;

            case SPTUSERTYPE_PRIVILEGED:
                break;
        }
    }


    # ---- PRIVATE INTERFACE -------------------------------------------------

}


?>
