<?PHP
#
#   FILE:  PreviewMessage.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2012-2013 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

function GetFromSession($VarName){
    $Value = NULL;
    if (isset($_SESSION[$VarName]))
    {
        $Value = $_SESSION[$VarName];
        unset ($_SESSION[$VarName]);
    }
    return $Value;
}

# ----- LOCAL FUNCTIONS ------------------------------------------------------

# ----- MAIN -----------------------------------------------------------------

# non-standard global variables

if (!isset($_GET["TI"]) )
{
    $H_ErrorMessages []= "No TopicId specified";
    return;
}

$H_Topic = new Topic($_GET["TI"]);

if ($H_Topic->GetErrorStatus() != Topic::OK)
{
    $H_ErrorMessages []= "Invalid TopicId specified";
    return;
}

if (isset($_GET["MI"]))
    $H_MessageId = intval($_GET["MI"]);

$H_Forum = new Forum( $H_Topic->ForumId() );

$H_Subject = GetFromSession("Subject");
$H_Body = GetFromSession("Body");

PageTitle("Preview Message");
