<?PHP
#
#   FILE:  ConfirmDeleteControlledName.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2004-2013 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

/**
* Print list of controlled names
*/
function PrintControlledNames()
{
    global $Session, $Name, $InUseCount;

    $CNArray = $Session->Get("CNArray");
    $Session->PassVariable("CNArray", $CNArray);

    foreach ($CNArray as $CNId)
    {
        $CN = new ControlledName($CNId);
        $Name = $CN->Name();
        $InUseCount = $CN->InUse();
        PrintControlledName();
    }
}

/**
* Print actual value
*/
function PrintControlledNameInfo()
{
    global $Name, $InUseCount;

    if ($InUseCount > 0) {
        print $Name." (This value in use by $InUseCount Resources)"; }
    else {
        print $Name." (This value is not currently in use)"; }
}

/**
* Print action value
*/
function PrintAction()
{
    global $Action;

    print $Action;
}

/**
* Print target value
*/
function PrintTarget()
{
    global $Target;

    print $Target;
}

# non-standard global variables
global $Action;
global $InUseCount;
global $Name;
global $Target;

if (!CheckAuthorization(PRIV_RESOURCEADMIN, PRIV_NAMEADMIN)) {  return;  }

$Action = $_GET["action"];
$Target = $_GET["target"];

# pass FieldName through
$Session->PassVariable("FieldName", $Session->Get("FieldName"));

PageTitle("Confirm Delete $Action");

?>
