<?PHP
#
#   FILE:  Entry.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2013 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

# ----- MAIN -----------------------------------------------------------------

$H_Blog = $GLOBALS["G_PluginManager"]->GetPluginForCurrentPage();

# assume that a generic error will occur
$H_State = "Error";

# get objet parameters
$EntryId = GetArrayValue($_GET, "ID");

# if the entry ID is invalid
if (!is_numeric($EntryId) || !Resource::ItemExists($EntryId))
{
    $H_State = "Invalid ID";
    return;
}

$H_Entry = new Blog_Entry($EntryId);
$H_Blog->SetCurrentBlog( $H_Entry->GetBlogId() );

# if the entry is some other type of resource
if (!$H_Blog->IsBlogEntry($H_Entry))
{
    $H_State = "Not Blog Entry";
    return;
}

# if the entry hasn't been published yet and the user can't view unpublished
# entries
if (!$H_Entry->UserCanView($GLOBALS["G_User"]))
{
    $H_State = "Entry Not Viewable";
    return;
}

# get the blog entry's metrics
$H_Metrics = $H_Blog->GetBlogEntryMetrics($H_Entry);

# record an event
$H_Blog->RecordBlogEntryView($H_Entry);

# if this entry is not from an "Email Blog" and someone tries to notify, jump
# back to this page with error
if (isset($_GET["Error"]))
{
    if (GetArrayValue($_GET, "Error") == "ERROR_NOT_EMAIL_BLOG")
    {
        $H_State = "Not Email Blog";
        return;
    }
}

# everything is fine
$H_State = "OK";

# signal view of full blog entry info
$GLOBALS["AF"]->SignalEvent("EVENT_FULL_RECORD_VIEW",
        array("ResourceId" => $H_Entry->Id()));
