<?PHP
#
#   FILE:  Pages_PageFactory.php (Pages plugin)
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2012-2014 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis
#

/**
* Factory class for Page objects (from Pages plugin).
*/
class Pages_PageFactory extends ResourceFactory {

    # ---- PUBLIC INTERFACE --------------------------------------------------

    /**
    * Class constructor.  The value for $SchemaId must be set before any
    * instances of this class are instantiated.
    */
    function __construct()
    {
        # error out if schema ID has not been set
        if (!isset(self::$SchemaId))
        {
            throw new Exception("Attempt to create PageFactory without"
                    ." schema ID being set.");
        }

        # set up resource factory base class
        parent::__construct(self::$SchemaId);
    }

    /**
    * Retrieve list of clean URLs for all pages.
    * @return Array with page indexes for index and clean URLs for values.
    */
    function GetCleanUrls()
    {
        # for each existing page
        $CleanUrls = array();
        $Ids = $this->GetItemIds();
        foreach ($Ids as $Id)
        {
            # retrieve clean URL and add to list
            $Page = new Pages_Page($Id);
            $CleanUrls[$Id] = $Page->Get("Clean URL");
        }

        # return clean URLs to caller
        return $CleanUrls;
    }

    /**
    * Metadata schema ID for pages.  Must be set before any instances of
    * this class are instantiated.
    */
    static $SchemaId;
}

