<?PHP
#
#   FILE:  SelectEditUserList.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2011-2013 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

# function to print the index value
function PrintIndex()
{
    global $Index;

    print $Index;
}

# functon to print Edit User Link
function PrintEditUserLink()
{
    global $FoundUserArray;

    $UserName = $FoundUserArray["UserName"];
    print "index.php?P=EditUser&amp;F_UserName=".$UserName;
}

# functon to print the User Description
function PrintUserName()
{
    global $FoundUserArray;

    $UserName = $FoundUserArray["UserName"];
    print htmlentities($UserName);
}

function PrintRealName()
{
    global $FoundUserArray;

    $RealName = $FoundUserArray["RealName"];
    print htmlentities($RealName);
}

function PrintEMail()
{
    global $FoundUserArray;

    $EMail = $FoundUserArray["EMail"];
    print htmlentities($EMail);
}

function PrintLastLoginDate()
{
    global $FoundUserArray;

    $LastLoginDate = $FoundUserArray["LastLoginDate"];
    print htmlentities($LastLoginDate);
}

function PrintAddress()
{
    global $FoundUserArray;

    $Address = $FoundUserArray["AddressLineOne"];
    print htmlentities($Address);
}

function PrintCity()
{
    global $FoundUserArray;

    $City = $FoundUserArray["City"];
    print htmlentities($City);
}

function PrintState()
{
    global $FoundUserArray;

    $State = $FoundUserArray["State"];
    print htmlentities($State);
}

function PrintZipCode()
{
    global $FoundUserArray;

    $ZipCode = $FoundUserArray["ZipCode"];
    print htmlentities($ZipCode);
}

function PrintCountry()
{
    global $FoundUserArray;

    $Country = $FoundUserArray["Country"];
    print htmlentities($Country);
}

# function to print the UserId
function PrintUserId()
{
    global $FoundUserArray;

    print $FoundUserArray["UserId"];
}

# function to return if any enabled option list fields exist
function UsersExist()
{
    global $UserArray;

    return count($UserArray);
}

# function to print number of users found
function PrintUsersFound()
{
    global $UserArray;

    print count($UserArray);
}

# display controlled name lists for editing
function DisplayUserList()
{
    global $Session;
    global $UFactory;
    global $UserArray;
    global $Index;
    global $FoundUserArray;
    global $NumberOfResults;
    global $StartingResult;
    global $ResultsPerPage;
    global $DB;

    PrintBegin();

    $NumberOfResults = $UFactory->GetMatchingUserCount();

    foreach ($UserArray as $UserId => $FoundUserArray)
    {
        DisplayUser();
    }
}

function DisplayUserListOnly()
{
    global $Session;
    global $UFactory;
    global $UserArray;
    global $Index;
    global $FoundUserArray;
    global $NumberOfResults;
    global $StartingResult;
    global $ResultsPerPage;
    global $DB;

    $NumberOfResults = $UFactory->GetMatchingUserCount();

    foreach ($UserArray as $UserId => $FoundUserArray)
    {
        DisplayUser();
    }
}

function PreviousResultsAvailable()
{
    global $StartingResult;

    return ($StartingResult > 0) ? TRUE : FALSE;
}

function NextResultsAvailable()
{
    global $StartingResult;
    global $ResultsPerPage;
    global $NumberOfResults;

    return (($StartingResult + $ResultsPerPage) < $NumberOfResults) ? TRUE : FALSE;
}

function PrintPreviousResultsLink()
{
    global $StartingResult;
    global $ResultsPerPage;

    $NewStartingResult = max(($StartingResult - $ResultsPerPage), 0);

    $PreviousLink = "index.php?P=SelectEditUserList"
        ."&amp;ResultsPerPage=".$ResultsPerPage
        ."&amp;StartingResult=". $NewStartingResult
        ."&amp;Text=";

    # search text from POST or GET?
    if (!empty($_POST['F_SearchText']))
        $PreviousLink .= $_POST['F_SearchText'];
    elseif (!empty($_GET['Text']))
        $PreviousLink .= $_GET['Text'];

    # search field from POST, GET or not at all?
    if (!empty($_POST['F_SearchField']))
        $PreviousLink .= "&amp;Field=". $_POST['F_SearchField'];
    elseif(!empty($_GET['Field']))
        $PreviousLink .= "&amp;Field=". $_GET['Field'];

    print($PreviousLink);
}

function PrintNextResultsLink()
{
    global $StartingResult;
    global $ResultsPerPage;

    $NewStartingResult = $StartingResult + $ResultsPerPage;

    $NextLink = "index.php?P=SelectEditUserList"
        ."&amp;ResultsPerPage=".$ResultsPerPage
        ."&amp;StartingResult=". $NewStartingResult
        ."&amp;Text=";

    # search text from POST or GET?
    if (!empty($_POST['F_SearchText']))
        $NextLink .= $_POST['F_SearchText'];
    elseif (!empty($_GET['Text']))
        $NextLink .= $_GET['Text'];

    # search field from POST, GET or not at all?
    if (!empty($_POST['F_SearchField']))
        $NextLink .= "&amp;Field=". $_POST['F_SearchField'];
    elseif(!empty($_GET['Field']))
        $NextLink .= "&amp;Field=". $_GET['Field'];

    print($NextLink);
}

function PrintNumberOfPreviousResults()
{
    global $ResultsPerPage;

    print($ResultsPerPage);
}

function PrintNumberOfNextResults()
{
    global $ResultsPerPage;
    global $StartingResult;
    global $NumberOfResults;

    print(min($ResultsPerPage, ($NumberOfResults - ($StartingResult + $ResultsPerPage))));
}

# ----- LOCAL FUNCTIONS ------------------------------------------------------

# ----- MAIN -----------------------------------------------------------------

# non-standard global variables
global $FoundUserArray;
global $Index;
global $NumberOfResults;
global $ResultsPerPage;
global $StartingResult;
global $UFactory;
global $UserArray;

if (!CheckAuthorization(PRIV_SYSADMIN, PRIV_USERADMIN)) {  return;  }

PageTitle("Edit/Delete Selected User(s)");

$UFactory = new CWUserFactory();
$UserArray = NULL;

$StartingResult = GetArrayValue($_GET, "StartingResult", 0);
$ResultsPerPage = GetArrayValue($_GET, "ResultsPerPage", 20);
$Submit = GetArrayValue($_POST, "Submit");

if ($Submit == "Search")
{
    $SearchText = GetArrayValue($_POST, "F_SearchText");
    $SearchField = GetArrayValue($_POST, "F_SearchField");

    if (!empty($SearchText))
    {
        $UserArray = $UFactory->GetMatchingUsers(
            $SearchText, $SearchField, $SearchField, $StartingResult, $ResultsPerPage);
    }
    else
    {
        $AF->SetJumpToPage("SelectEditUser");
        return;
    }
}

# return all users
else if ($Submit == "Return All Users")
{
    $UserArray = $UFactory->GetMatchingUsers(
        ".*.",
        NULL,
        "UserName",
        $StartingResult,
        $ResultsPerPage);
}

# came here from a next/previous link
else
{
    $Text = GetArrayValue($_GET, "Text");
    $Field = GetArrayValue($_GET, "Field");

    if (isset($Text))
    {
        if (!empty($Text))
        {
            $UserArray = $UFactory->GetMatchingUsers(
                $Text, $Field, $Field, $StartingResult, $ResultsPerPage);
        }
        else
        {
            $UserArray = $UFactory->GetMatchingUsers(
                ".*.", NULL, $Field, $StartingResult, $ResultsPerPage);
        }
    }
    else
    {
       $AF->SetJumpToPage("SelectEditUser");
       return;
    }
}
